using System;
using System.Data;
using System.Configuration;
using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.Common
{
    
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> 
	///WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified
	///</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>6/11/2003</CreationDate>
	///<Note>
	///The Food and Drug Administration classifies this software as a medical device.  
	///As such, it may not be changed in any way. Modifications to this software may result 
	///in an adulterated medical device under 21CFR820, the use of which is considered to 
	///be a violation of US Federal Statutes.  Acquiring and implementing this software through 
	///the Freedom of information Act requires the implementor to assume total responsibility 
	///for the software, and become a registered manufacturer of a medical device, subject 
	///to FDA regulations
	///</Note>
	/// <summary>
	/// Summary description for VBECSDateTime.
	/// </summary>
	
	#endregion

	
	public class VBECSDateTime 
	{
		#region Variables

		/// <summary>
		///holds date custom format 
		/// </summary>
		private static string _dateFormat;
		/// <summary>
		/// holds date and time custom format
		/// </summary>
		private static string _dateTimeFormat;
		/// <summary>
		/// holds date and time long custom fromat
		/// </summary>
		private static string _dateTimeLongFormat;
		/// <summary>
		/// holds time custom format
		/// </summary>
		private static string _timeFormat;
		/// <summary>
		/// holds time long custom format
		/// </summary>
		private static string _timeLongFormat;

		#endregion


		#region Constructors/Dispose
			
		#endregion

		#region Properties

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="692"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DateFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="695"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Custom Date Format
		/// </summary>
		public static string DateFormat
		{
			get
			{
				if(_dateFormat == null || _dateFormat == String.Empty)
				{
					_dateFormat = VbecsConfig.Current.DateFormat;
				}
				return _dateFormat;
			}
		}		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="696"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DateTimeFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="697"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Custom Date and Time Format
		/// </summary>
		public static string DateTimeFormat
		{
			get
			{
				if(_dateTimeFormat == null || _dateTimeFormat == String.Empty)
				{
					_dateTimeFormat = VbecsConfig.Current.DateTimeFormat;
				}
				return _dateTimeFormat;
			}
		}		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="698"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>LongDateTimeFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="701"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Custom Date and Time Long Format
		/// </summary>
		public static string DateTimeLongFormat
		{
			get
			{
				if(_dateTimeLongFormat == null || _dateTimeLongFormat == String.Empty)
				{
					_dateTimeLongFormat = VbecsConfig.Current.LongDateTimeFormat;
				}
				return _dateTimeLongFormat;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="702"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>TimeFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="703"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Custom Time Format
		/// </summary>
		public static string TimeFormat
		{
			get
			{
				if(_timeFormat == null || _timeFormat == String.Empty)
				{
					_timeFormat = VbecsConfig.Current.TimeFormat;
				}
				return _timeFormat;
			}
		}		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="704"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>LongTimeFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="705"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Custom Time Long Format
		/// </summary>
		public static string TimeLongFormat
		{
			get
			{
				if(_timeLongFormat == null || _timeLongFormat == String.Empty)
				{
					_timeLongFormat = VbecsConfig.Current.LongTimeFormat;
				}
				return _timeLongFormat;
			}
		}		

		#endregion

		#region Methods

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="706"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>DateFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="707"> 
		///		<ExpectedInput>empty string</ExpectedInput>
		///		<ExpectedOutput>empty string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This function will format a date variable into a string
		/// in the format specified the the app.config file.
		/// </summary>
		/// <returns></returns>
		public static string FormatDateString(string inDate)
		{
			if(inDate != String.Empty)
			{
				return Convert.ToDateTime(inDate).ToString(VbecsConfig.Current.DateFormat);
			}
			else
			{
				return String.Empty;
			}
		}
		
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="708"> 
		///		<ExpectedInput>Object with date</ExpectedInput>
		///		<ExpectedOutput>DateFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="710"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>empty string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FormatDateString
		/// </summary>
		/// <param name="inDate"></param>
		/// <returns></returns>
		public static string FormatDateString(object inDate)
		{
			if ((inDate != null ) && (inDate != System.DBNull.Value))
			{
				return Convert.ToDateTime(inDate).ToString(VbecsConfig.Current.DateFormat);
			}
			else
			{
				return String.Empty;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="711"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>DateTimeFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="712"> 
		///		<ExpectedInput>empty string</ExpectedInput>
		///		<ExpectedOutput>empty string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This function will format a date and time variable into a string
		/// in the format specified the the app.config file.
		/// </summary>
		/// <returns></returns>
		public static string FormatDateTimeString(string inDate)
		{
			if(inDate != String.Empty)
			{
				return Convert.ToDateTime(inDate).ToString(VbecsConfig.Current.DateTimeFormat);
			}
			else
			{
				return String.Empty;
			}
		}
		
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="713"> 
		///		<ExpectedInput>date string in object</ExpectedInput>
		///		<ExpectedOutput>DateTimeFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="714"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>Empty string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FormatDateTimeString
		/// </summary>
		/// <param name="inDate"></param>
		/// <returns></returns>
		public static string FormatDateTimeString(object inDate)
		{
			if ((inDate != null ) && (inDate != System.DBNull.Value))
			{
				return Convert.ToDateTime(inDate).ToString(VbecsConfig.Current.DateTimeFormat);	
			}
			else
			{
				return String.Empty;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="715"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>LongDateTimeFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="716"> 
		///		<ExpectedInput>empty string</ExpectedInput>
		///		<ExpectedOutput>empty string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This function will format a date and time (including seconds) variable into a string
		/// in the format specified the the app.config file.
		/// </summary>
		/// <returns></returns>
		public static string FormatDateLongTimeString(string inDate)
		{
			if(inDate != String.Empty)
			{
				return Convert.ToDateTime(inDate).ToString(VbecsConfig.Current.LongDateTimeFormat);
			}
			else
			{
				return String.Empty;
			}
		}
		
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="717"> 
		///		<ExpectedInput>Object</ExpectedInput>
		///		<ExpectedOutput>LongDateTimeFormat string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="718"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>empty string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FormatDateLongTimeString
		/// </summary>
		/// <param name="inDate"></param>
		/// <returns></returns>
		public static string FormatDateLongTimeString(object inDate)
		{
			if ((inDate != null ) && (inDate != System.DBNull.Value))
			{
				return Convert.ToDateTime(inDate).ToString(VbecsConfig.Current.LongDateTimeFormat);	
			}
			else
			{
				return String.Empty;
			}
		}

		///<Developers>
		///<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/23/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8260"> 
		///		<ExpectedInput>dates</ExpectedInput>
		///		<ExpectedOutput>0</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8261"> 
		///		<ExpectedInput>different dates</ExpectedInput>
		///		<ExpectedOutput>1</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Compare two VBECS Dates, ignoring seconds
		/// </summary>
		/// <param name="firstDate"></param>
		/// <param name="secondDate"></param>
		/// <returns>1 = first date greater than second date, 0 = same date, -1 = first date greater than second date</returns>
		public static int CompareDates(DateTime firstDate, DateTime secondDate)
		{
			//Strip off secs before comparing dates
			System.DateTime firstDateNoSecs = new DateTime(firstDate.Year, firstDate.Month, firstDate.Day, firstDate.Hour, firstDate.Minute, 0);
			System.DateTime secondDateNoSecs = new DateTime(secondDate.Year, secondDate.Month, secondDate.Day, secondDate.Hour, secondDate.Minute, 0);
			//Compare dates
			return firstDateNoSecs.CompareTo(secondDateNoSecs);
		}
	}
	#endregion
}